#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
SmokeTest_V_runTestsOnlyCLI

Contact: vanberckel@apple.com
2010/04/02
"""

import subprocess

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Runs the built-in unit tests directly from the finder binary" # Add a brief description of test functionality
testVersion      = "1.0"              # Used to differentiate between results for different versions of the test
testState        = ProductionState   # Possible values: DevelopmentState, ProductionState


def runTest(params):
	# Your testing code here
	run32bit()
	run64bit()

@runAsSubTest("Built-in unit tests --runTestsOnly for 32bit")
def run32bit():
	ret = run(["arch", "-i386", "/System/Library/CoreServices/Finder.app/Contents/MacOS/Finder", "--runTestsOnly"])
	if (ret['status'] == 0):
		logPass()
	else:
		failmsg = ret['output']
		logFail(failmsg)

@runAsSubTest("Built-in unit tests --runTestsOnly for 64bit")
def run64bit():
	ret = run(["arch", "-x86_64", "/System/Library/CoreServices/Finder.app/Contents/MacOS/Finder", "--runTestsOnly"])
	if (ret['status'] == 0):
		logPass()
	else:
		failmsg = ret['output']
		logFail(failmsg)


def run(command, shell=False):
	(reader, writer) = os.pipe()

	child = subprocess.Popen(command, stdout=writer, stderr=writer, shell=shell)
	os.close(writer)
	output = []
	s = os.read(reader, 1024)
	while s:
		sys.stdout.write(s)
		output.append(s)
		s = os.read(reader, 1024)
	output = ''.join(output)
	child.wait()
	return {"output": output, "status": child.returncode}

