#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("~finder/Automation/raft-wrapper.py")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
TestFinderGoMenu

Contact: vanberckel@apple.com
2010/02/08
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Goes through most items in the Go menu, selects it, and verifies that it opens - Except Computer, and Home."                 # Add a brief description of test functionality
testVersion      = "1.0"              # Your test version must be increased if you change testCustomDBSpec or testState
testState        = ProductionState   # Possible values: DevelopmentState, ProductionState



def runTest(params):
	# Your testing code here
	raftlibs.finder.closeAllWindows()
	
	target.processes()["Finder"].menus()["Go"].menuItems()["Computer"].choose()
	target.delayForTimeInterval_(2)
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()["Home"].choose()
	target.delayForTimeInterval_(2)
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()["Desktop"].choose()
	target.delayForTimeInterval_(2)
	assert(target.processes()["Finder"].mainWindow().name() == "Desktop")
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()["Downloads"].choose()
	target.delayForTimeInterval_(2)
	assert(target.processes()["Finder"].mainWindow().name() == "Downloads")
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()["Network"].choose()
	target.delayForTimeInterval_(2)
	assert(target.processes()["Finder"].mainWindow().name() == "Network")
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()["Applications"].choose()
	target.delayForTimeInterval_(2)
	assert(target.processes()["Finder"].mainWindow().name() == "Applications")
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()["Documents"].choose()
	target.delayForTimeInterval_(2)
	assert(target.processes()["Finder"].mainWindow().name() == "Documents")
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()["Utilities"].choose()
	target.delayForTimeInterval_(2)
	assert(target.processes()["Finder"].mainWindow().name() == "Utilities")
	keyboard.typeString_withModifiersMask_("w", (kUIACommandKeyMask))
	
	
	logPass() # This line is implicit and can be removed
