#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("~finder/Automation/raft-wrapper.py")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
TestFinderPrefs

Contact: vanberckel@apple.com
2010/01/28
"""

# This is a RAFT test. For more information see http://dzone200/wiki/RAFT
testDescription		= "Goes through each Pref item, and selects it. Does not verify the selection or its consequences. *Should* halt on a crash."				# Add a brief description of test functionality
testVersion			= "1.2"				# Your test version must be changed if you change testCustomDBSpec or testState
testState			= ProductionState  # Possible values: DevelopmentState, ProductionState
testCustomDBSpec	= {}				# for the exceptional case when custom data fields are needed (see wiki)

def PrefsWindow():
	prefsWindow = target.processes()["Finder"].mainWindow()
	assert (prefsWindow.name() == "Finder Preferences")
	return prefsWindow


def ToolbarButtons():
	return PrefsWindow().toolbar().buttons()


def prepareScenario(params):
	#raftlibs.finder.launchFinderClean()
	raftlibs.finder.closeAllWindows()
	keyboard.typeString_withModifiersMask_("n", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Finder"].menuItems()[u"Preferences…"].choose()
	PrefsWindow().dragTo_((300,40))

	
@runAsSubTest("Test the General Preference Tab")
def testGeneralPreferences():
	try:
		ToolbarButtons()["General"].click()

		# toggle each of the checkboxes
		checkboxes = PrefsWindow().checkboxes()
		for checkbox in checkboxes:
			checkbox.click()
		for checkbox in checkboxes:
			checkbox.click()
			
		# open the New Finder Windows popup, and then cancel it
		# in order to prime the menu
		newWindowPopUpButton = PrefsWindow().popUpButtons()["New Finder windows show:"]
		newWindowPopUpButton.openMenu()
		keyboard.typeVirtualKey_(kVK_Escape)

		# Cycle through the menu items.  Skip separator items and Other…
		#
		# [TODO] Open/close a new window and verify that its targeted to the correct location
		newWindowPopUpButton = PrefsWindow().popUpButtons()["New Finder windows show:"]
		newWindowMenuItems = newWindowPopUpButton.openMenu().menuItems().withPredicate_(u'isSeparatorItem != True and name != "Other…"')
		oldMenuItem = newWindowMenuItems[newWindowPopUpButton.value()]
		for menuItem in newWindowMenuItems:
			menuItem.choose()

		# restore the old setting
		oldMenuItem.choose()

	except Exception:
		logFail("FAILED the General Preference Tab")
		
		
def testChangingLabel(index, newText):
		labelTextField = PrefsWindow().textFields()[index]
		labelTextField.click()
		oldValue = labelTextField.value()
		keyboard.typeString_withModifiersMask_("a", (kUIACommandKeyMask))
		keyboard.typeString_(newText)
		return oldValue


@runAsSubTest("Test the Labels Preference Tab")
def testLabelsPreferences():
	try:
		ToolbarButtons()["Labels"].click()
		
		# set new color label names
		oldLabel6 = testChangingLabel(6, "Red Colour")
		oldLabel5 = testChangingLabel(5, "Orange Colour")
		oldLabel4 = testChangingLabel(4, "Yellow Colour")
		oldLabel3 = testChangingLabel(3, "Green Colour")
		oldLabel2 = testChangingLabel(2, "Blue Colour")
		oldLabel1 = testChangingLabel(1, "Purple Colour")
		oldLabel0 = testChangingLabel(0, "Gray Colour")
		
		# restore to old names
		testChangingLabel(6, oldLabel6)
		testChangingLabel(5, oldLabel5)
		testChangingLabel(4, oldLabel4)
		testChangingLabel(3, oldLabel3)
		testChangingLabel(2, oldLabel2)
		testChangingLabel(1, oldLabel1)
		testChangingLabel(0, oldLabel0)
	except Exception:
		logFail("FAILED the Labels Preference Tab")
	
	
@runAsSubTest("Test the Sidebar Preference Tab")
def testSidebarPreferences():
	try:
		ToolbarButtons()["Sidebar"].click()

		# toggle each of the checkboxes
		checkboxes = PrefsWindow().checkboxes()
		for checkbox in checkboxes:
			checkbox.click()
		for checkbox in checkboxes:
			checkbox.click()

	except Exception:
		logFail("FAILED the Sidebar Preference Tab")
	
			
@runAsSubTest("Test the Advanced Preference Tab")
def testAdvancedPreferences():
	try:
		ToolbarButtons()["Advanced"].click()

		# toggle each of the checkboxes
		checkboxes = PrefsWindow().checkboxes()
		for checkbox in checkboxes:
			checkbox.click()
		for checkbox in checkboxes:
			checkbox.click()

		searchPopUpButton = PrefsWindow().popUpButtons()["When performing a search:"]
		searchMenuItems = searchPopUpButton.openMenu().menuItems()
		oldMenuItem = searchMenuItems[searchPopUpButton.value()]
		for menuItem in searchMenuItems:
			menuItem.choose()

		# restore the old setting
		oldMenuItem.choose()
		
	except Exception:
		logFail("FAILED the Advanced Preference Tab")


def runTest(params):
	
	testGeneralPreferences()
	testLabelsPreferences()
	testSidebarPreferences()
	testAdvancedPreferences()

	logPass() # This line is implicit and can be removed
		
def finishTest(params):
	PrefsWindow().closeButton().click()
