#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("~finder/Automation/raft-wrapper.py")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
SmokeTest_N_RunThruCustomizeToolBar

Contact: vanberckel@apple.com
2010/02/08
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Run Through all items in Customizing the ToolBar"                 # Add a brief description of test functionality
testVersion      = "1.0"              # Your test version must be increased if you change testCustomDBSpec or testState
testState        = ProductionState   # Possible values: DevelopmentState, ProductionState


def removeAllToolbarItemsWithCommand():
	try:
		target.processes()["Finder"].mainWindow().sheet().buttons()["Done"].click()
	except:
		pass
	for index in range(len(target.processes()["Finder"].mainWindow().toolbar().elements())):
		hitpoint = target.processes()["Finder"].mainWindow().toolbar().elements()[0].hitpoint()
		if (hitpoint != None):  #This is to get around the fact that separators & space count in the item list, but cannot be removed
			keyboard.pressKey_(kVK_Command)
			#mouse.dragFrom_to_(target.processes()["Finder"].mainWindow().toolbar().elements()[0], (hitpoint.x + 0, hitpoint.y + 50))
			mouse.dragFrom_to_((hitpoint.x, hitpoint.y), (hitpoint.x + 0, hitpoint.y + 50))
			keyboard.releaseKey_(kVK_Command)

def removeAllToolbarItemsWithSheet():
	target.processes()["Finder"].menus()["View"].menuItems()[u"Customize Toolbar…"].choose()
	toolbarItemList = target.processes()["Finder"].mainWindow().toolbar().elements()
	for index in range(len(toolbarItemList)):
		hitpoint = target.processes()["Finder"].mainWindow().toolbar().hitpoint()
		leftSide = target.processes()["Finder"].mainWindow().toolbar().bounds()
		if (hitpoint != None):
			leftItem = hitpoint.x - (leftSide.size.width/2) + 20	
			mouse.dragFrom_to_((leftItem, hitpoint.y), (leftItem + 0, hitpoint.y + 50))
	target.processes()["Finder"].mainWindow().sheet().buttons()["Done"].click()

def addAllToolbarItemsWithSheet():
	target.processes()["Finder"].menus()["View"].menuItems()[u"Customize Toolbar…"].choose()
	toolBarItems = len(target.processes()["Finder"].mainWindow().sheet().elements()[6].elements())
	for index in range(toolBarItems):
		hitpoint1 = target.processes()["Finder"].mainWindow().sheet().elements()[6].elements()[index].hitpoint()
		hitpoint2 = target.processes()["Finder"].mainWindow().toolbar().hitpoint()
		mouse.dragFrom_to_((hitpoint1.x, hitpoint1.y),(hitpoint2.x, hitpoint2.y))
	target.processes()["Finder"].mainWindow().sheet().buttons()["Done"].click()
	
def runTest(params):
	# Your testing code here
	
	raftlibs.finder.closeAllWindows()
	
	keyboard.typeString_withModifiersMask_("n", (kUIACommandKeyMask))
	
	raftlibs.finder.resetToolbarState()
	removeAllToolbarItemsWithCommand()
	raftlibs.finder.resetToolbarState()
	removeAllToolbarItemsWithSheet()
	raftlibs.finder.resetToolbarState()
	
	target.processes()["Finder"].menus()["View"].menuItems()[u"Customize Toolbar…"].choose()
	target.processes()["Finder"].mainWindow().sheet().popUpButtons()[0].openMenu().menuItems()["Icon and Text"].choose()
	target.processes()["Finder"].mainWindow().sheet().checkboxes()["Use small size"].click()
	target.processes()["Finder"].mainWindow().sheet().buttons()["Done"].click()

	addAllToolbarItemsWithSheet()
	removeAllToolbarItemsWithCommand()
	addAllToolbarItemsWithSheet()
	removeAllToolbarItemsWithSheet()
	
	logPass() # This line is implicit and can be removed
	
def finishTest(params):
	raftlibs.finder.resetToolbarState()