#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
SmokeTest_N_MountDMG

Contact: Justin van Berckel
2010/08/03
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Mounts a DMG with 9 Partitions 5 times, while targeted to computer, and with external disks on for desktop"                 # Add a brief description of test functionality
testVersion      = "1.0"              # Used to differentiate between results for different versions of the test
testState        = DevelopmentState   # Possible values: DevelopmentState, ProductionState

import random


def prepareScenario(params):
	raftlibs.finder.activateFinder()
	raftlibs.finder.toggleFinderGeneralPreference("Hard disks", "off")
	raftlibs.finder.toggleFinderGeneralPreference("External disks", "on")
	raftlibs.finder.toggleFinderGeneralPreference("other", "off")
	raftlibs.finder.toggleFinderGeneralPreference("Connected servers", "off")
	raftlibs.finder.closeAllWindows()
	target.processes()["Finder"].menus()["Go"].menuItems()["Computer"].choose()
	commandOutput = doCommand("unzip", "-u", "GUIDDiskImage.dmg.zip")
	if commandOutput['status'] != 0:
		raise Exception("Disk Image Failed to Unzip" + str(commandOutput['stdout']))

def mountDiskImage():
	commandOutput = doCommand("hdiutil", "attach", "GUIDDiskImage.dmg")
	if commandOutput['status'] != 0:
		raise Exception("Disk Image Failed to Mount" + str(commandOutput['stdout']))
#	assert (raftlibs.finder.fileExists("GUIDDiskImage.dmg"))
	target.delayForTimeInterval_(1)

def unmountDiskImage():
	commandOutput = doCommand("diskutil", "unmountDisk", "/Volumes/MountedDMG 1") #Unmounting one seems to unmount all
	if commandOutput['status'] != 0:
		raise Exception("Disk Image Failed to Unmount")
	target.delayForTimeInterval_(1)
		
def runTest(params):
	for i in range(0, 5):
		keyboard.typeString_withModifiersMask_("c", (kUIAShiftKeyMask|kUIACommandKeyMask))#this is necessary because flow view will retarget you
		keyboard.typeString_withModifiersMask_(str(random.randrange(1,5)), (kUIACommandKeyMask))#choose a random view
		mountDiskImage()
		target.delayForTimeInterval_(3)
		unmountDiskImage()
		target.delayForTimeInterval_(3)
		
# def finishTest(params):
	# Return to a state so the test may be run again

def cleanupScenario(params):
	# Cleanup any changes done by your test
	raftlibs.finder.deleteFileOrFolder("GUIDDiskImage.dmg")