#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
RunAllFinderRaftTests

Contact: Lindsey H
2009/11/09
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "This is the Finder QuickLooks Suite"                 # Add a brief description of test functionality
testVersion      = "0.9"              # Used to differentiate between results for different versions of the test
testState        = DevelopmentState   # Possible values: DevelopmentState, ProductionState


# Your testing code here
def runRaftTestAsSibling(testNameOrPath, testArguments={}, raftArguments=()):
	"""Run an entire Raft test. 
	
	If testNameOrPath begins with a / it is treated as a path to an on-disk test. 
	Otherwise, the test is checked out from subversion and run from the checkout location.
	
	testArguments is an optional dictionary of keys and values to pass as the params dict for the new test.
	raftArguments is an optional tuple of addtional arguments to pass to the Raft subprocess.
	"""
	import subprocess
	import LoggingInterface
	import harness_options
	
	logger = LoggingInterface._logger
	print logger;
	
	raftPath = os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft"))
	childTestPath = os.path.expanduser(testNameOrPath)
	
	testCommand = []
	
	testCommand.append(raftPath)
	if testNameOrPath.startswith("/"):
		testCommand.append("-f")
	
	if harness_options.CLIOptions.activeLogging == True:
		testCommand.append("--log")
		testCommand.append("--parent-log-id=%s" % (LoggingInterface.topLogger().logId))
	
	if childTestPath.startswith("/"):
		testCommand.append("-f")
	testCommand.append(childTestPath)
	print childTestPath
	print "Preparing Raft Test '%s'" % (testNameOrPath)
	ret = subprocess.call(testCommand)	
	return ret

def runTest(params):
	#need to add setup
	#You can run a test from a path, or using the name if it is in svn
	
	fileList =	["QuickLook_N_RunThruGetInfoWindow",
				#"QuickLook_V_AddItemToToolbar",
				"QuickLook_V_BasicGoTo",
				"QuickLook_V_FinderCopyReplaceFile",
				"QuickLook_V_FinderCopySingleFile",
				"QuickLook_V_RenameFilesAndFolders",
				"SmokeTest_N_MountDMG",
				"SmokeTest_N_RunThruCustomizeToolBar",
				"SmokeTest_N_RunThruFinderPrefs",
				"SmokeTest_V_RunThruFinderGoMenu",]	
		
	for test in fileList:
		ret = runRaftTestAsSibling(test)
		if ret !=0:
			print test + " Test Failed"
			return
