#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("~finder/Automation/raft-wrapper.py")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
Rename Test

Contact: Lindsey H
2009/11/03
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "QuickLook Test for Renaming Files And Folders"                 # Add a brief description of test functionality
testVersion      = "1.0"              # Your test version must be increased if you change testCustomDBSpec or testState
testState        = ProductionState   # Possible values: DevelopmentState, ProductionState
testCustomDBSpec = {}                 # for the exceptional case when custom data fields are needed (see wiki)
newFolderName = "New_Folder_Rename_Test"
newFolderPath = "~/%s" % newFolderName

def inlineRename(name):
	keyboard.typeVirtualKey_(36)
	keyboard.typeString_(name)
	keyboard.typeVirtualKey_(36)


def inlineRenameTest(viewStyle, name):
	raftlibs.finder.closeAllWindows()
	#rename test: Rename in all view styles
	keyboard.typeString_withModifiersMask_("h", (kUIAShiftKey|kUIACommandKey))
	keyboard.typeString_withModifiersMask_(viewStyle, (kUIACommandKey))
	keyboard.typeString_withModifiersMask_("n", (kUIAShiftKey|kUIACommandKey))
	keyboard.typeVirtualKey_(36)
	inlineRename(name)

def verifyExists(path):
	if raftlibs.finder.fileExists(path):
		logPass()
	else:
		logFail()

@runAsSubTest("ListView Inline Rename")
def listViewInlineRename():
	#list view		
	inlineRenameTest("2", newFolderName)
	verifyExists(newFolderPath)
	raftlibs.finder.deleteFileOrFolder(newFolderPath)
		
@runAsSubTest("IconView Inline Rename")
def iconViewInlineRename():
	#icon view		
	inlineRenameTest("1", newFolderName)
	verifyExists(newFolderPath)
	raftlibs.finder.deleteFileOrFolder(newFolderPath)
	
@runAsSubTest("ColumnView Inline Rename")
def columnViewInlineRename():
	#column view		
	inlineRenameTest("3", newFolderName)
	verifyExists(newFolderPath)
	raftlibs.finder.deleteFileOrFolder(newFolderPath)

@runAsSubTest("FlowView Inline Rename Test")
def flowViewInlineRename():
	#flow view		
	inlineRenameTest("4", newFolderName)
	verifyExists(newFolderPath)
	raftlibs.finder.deleteFileOrFolder(newFolderPath)
	
@runAsSubTest("Desktop Rename Test")
def desktopRenameTest():
	doCommand("touch",os.path.expanduser("~/Desktop/foo.txt"))
	raftlibs.finder.closeAllWindows()
	#Create a file on the Desktop
	keyboard.typeString_("foo")
	inlineRename("newfoo")
	verifyExists("~/Desktop/newfoo.txt")
	#undo
	raftlibs.finder.deleteFileOrFolder("~/Desktop/newfoo.txt")
	
@runAsSubTest("Info Rename Test")
def infoRenameTest():
	doCommand("touch",os.path.expanduser("~/Desktop/foo.txt"))
	raftlibs.finder.closeAllWindows()
	keyboard.typeString_withModifiersMask_("d", (kUIAShiftKey|kUIACommandKey))
	keyboard.typeString_withModifiersMask_("2", (kUIACommandKey))
	keyboard.typeString_("foo")
	#open the info window
	keyboard.typeString_withModifiersMask_("i", (kUIACommandKey))
	target.delayForTimeInterval_(2)
	try:
		target.processes()["Finder"].mainWindow().scrollViews()[0].textFields()[0].click()
	except:
		keyboard.pressKey_(kVK_Option)
		target.processes()["Finder"].mainWindow().scrollViews()[0].disclosureTriangles()["Name & Extension:"].click()
		keyboard.releaseKey_(kVK_Option)
		target.delayForTimeInterval_(2)
		target.processes()["Finder"].mainWindow().scrollViews()[0].textFields()[0].click()
		
		
	#Go to the beginning of the text field
	keyboard.typeString_withModifiersMask_("a", (kUIAControlKey))
	keyboard.typeString_("new")
	keyboard.typeVirtualKey_(36)
	verifyExists("~/Desktop/newfoo.txt")
	#undo
	raftlibs.finder.deleteFileOrFolder("~/Desktop/newfoo.txt")



def runTest(params):

	if not raftlibs.finder.deleteFileOrFolder(newFolderPath):
		logFail("Failure to delete the new folder %s" % newFolderPath)
	
	listViewInlineRename()
	iconViewInlineRename()
	columnViewInlineRename()
	flowViewInlineRename()
	
	desktopRenameTest()
	infoRenameTest()
		
	

