#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
QuickLook_V_MountDMGRepeatedly

Contact: Jonathan Chang
2010/08/03
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Mounts a DMG with 9 Partitions ten times and verifies they mounted and unmounted correctly using clip matching"                 # Add a brief description of test functionality
testVersion      = "1.0"              # Used to differentiate between results for different versions of the test
testState        = DevelopmentState   # Possible values: DevelopmentState, ProductionState

def prepareScenario(params):
	raftlibs.finder.quitFinder()
	raftlibs.finder.resetFinderToDefaults()	

### Setting these preferences new when no preference plist file exists causes the desktop to revert to 48x48 icon size
#	doCommand("defaults", "write", "com.apple.finder", "ShowHardDrivesOnDesktop", 0)   
#	doCommand("defaults", "write", "com.apple.finder", "ShowExternalHardDrivesOnDesktop", 1)
#	doCommand("defaults", "write", "com.apple.finder", "ShowRemovableMediaOnDesktop", 0)
#	doCommand("defaults", "write", "com.apple.finder", "ShowMountedServersOnDesktop", 0)
#	raftlibs.finder.activateFinder()
#	raftlibs.finder.closeAllWindows()
	
	raftlibs.finder.activateFinder()
	raftlibs.finder.toggleFinderGeneralPreference("Hard disks", "off")
	raftlibs.finder.toggleFinderGeneralPreference("External disks", "on")
	raftlibs.finder.toggleFinderGeneralPreference("other", "off")
	raftlibs.finder.toggleFinderGeneralPreference("Connected servers", "off")
	raftlibs.finder.closeAllWindows()
	target.processes()["Finder"].menus()["Go"].menuItems()["Computer"].choose()
	commandOutput = doCommand("unzip", "-u", "GUIDDiskImage.dmg.zip")
	if commandOutput['status'] != 0:
		raise Exception("Disk Image Failed to Unzip" + str(commandOutput['stdout']))

def mountDiskImage():
	commandOutput = doCommand("hdiutil", "attach", "GUIDDiskImage.dmg")
	if commandOutput['status'] != 0:
		raise Exception("Disk Image Failed to Mount" + str(commandOutput['stdout']))
	
	target.delayForTimeInterval_(3)

def unmountDiskImage():
	commandOutput = doCommand("diskutil", "unmountDisk", "/Volumes/MountedDMG 1") #Unmounting one seems to unmount all
	if commandOutput['status'] != 0:
		raise Exception("Disk Image Failed to Unmount")
		
	target.delayForTimeInterval_(5)
		
def runTest(params):
	for i in range(0, 10):
		mountDiskImage()
		failures = []
		diskImageClip = target.clipAtPath_(os.path.join(os.getcwd(), "DiskImageClip.png"))
		mainScreenBounds = target.mainScreen().bounds()
		# Matches 6 disk images in the rightmost column of the Desktop
		# If external disks are mounted this will fail
		clipLocationX = mainScreenBounds.size.width - 74
		clipLocationY = 56.0
		for x in range(0, 6):
			diskImageRect = (clipLocationX, clipLocationY, 31, 31)
			if diskImageClip.findInRect_confidence_(diskImageRect, 0.92) == None:
				failures.append(str(x + 1))
			clipLocationY = clipLocationY + 110
		print failures
		if len(failures) > 0:
			print "Incorrect Disk Image Position(s): " + str(failures) + " on Trial " + str(i + 1)
			raise Exception("Incorrect Disk Image Position")
		
		unmountDiskImage()
		
# def finishTest(params):
	# Return to a state so the test may be run again

def cleanupScenario(params):
	# Cleanup any changes done by your test
	raftlibs.finder.deleteFileOrFolder("GUIDDiskImage.dmg")