#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft")), "-f"] + sys.argv
	os.execv(args[0], args)
	
"""
QuickLook_V_FinderCopyReplaceFile

Contact: vanberckel@apple.com
2009/12/16
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Copies a single file, replaces it, and verifies the copy"                 # Add a brief description of test functionality
testVersion      = "1.0"              # Your test version must be increased if you change testCustomDBSpec or testState
testState        = ProductionState   # Possible values: DevelopmentState, ProductionState

import random

Folder1 = "TemporaryFolder1-" + str(random.randrange(100,200))
Folder2 = "TemporaryFolder2-" + str(random.randrange(200,300))
	
FolderFullPath1 = os.path.expanduser("~") + "/Desktop/" + Folder1
FolderFullPath2 = os.path.expanduser("~") + "/Desktop/" + Folder2
FileToCopy1 = FolderFullPath1+ "/" + "FileToCopy"
FileToCopy2 = FolderFullPath2+ "/" + "FileToCopy"

def prepareScenario(params):

	raftlibs.finder.closeAllWindows()
	
	doCommand("mkdir","-p", FolderFullPath1)
	doCommand("mkdir","-p", FolderFullPath2)
	doCommand("dd","if=/dev/random", "of="+FileToCopy1,"bs=1000", "count=10000")    #10MB in base 10
	doCommand("dd","if=/dev/random", "of="+FileToCopy2,"bs=1000", "count=10000")    #10MB in base 10

	
	target.processes()["Finder"].menus()["Go"].menuItems()[u"Go to Folder…"].choose()
	#keyboard.typeString_withModifiersMask_("g", (kUIAShiftKeyMask|kUIACommandKeyMask))
	keyboard.typeString_("~/Desktop/")
	keyboard.typeString_(Folder1)
	keyboard.typeVirtualKey_(kVK_Return)
	
	target.processes()["Finder"].menus()["View"].menuItems()["as Icons"].choose()
	#keyboard.typeString_withModifiersMask_("1", (kUIACommandKeyMask))
	
	doCommand("osascript", "-e", "tell application \"Finder\" to set bounds of window 1 to {30, 70, 800, 485}")
	
	target.processes()["Finder"].menus()["File"].menuItems()["New Finder Window"].choose()
	#keyboard.typeString_withModifiersMask_("n", (kUIACommandKeyMask))
	target.processes()["Finder"].menus()["Go"].menuItems()[u"Go to Folder…"].choose()
	#keyboard.typeString_withModifiersMask_("g", (kUIAShiftKeyMask|kUIACommandKeyMask))
	keyboard.typeString_("~/Desktop/")
	keyboard.typeString_(Folder2)
	keyboard.typeVirtualKey_(kVK_Return)

	target.processes()["Finder"].menus()["View"].menuItems()["as Icons"].choose()
	#keyboard.typeString_withModifiersMask_("1", (kUIACommandKeyMask))
	
	doCommand("osascript", "-e", "tell application \"Finder\" to set bounds of window 1 to {330, 370, 1100, 785}")

	#doCommand("osascript", "openTwoWindows.applescript")
	
	#should verify test preparation here.
	
def runTest(params):
	# Your testing code here
	
	target.processes()["Finder"].mainWindow().scrollViews()[0].groups()["Image browser"].images()["FileToCopy"].click()
	target.delayForTimeInterval_(.5)
	keyboard.typeString_withModifiersMask_("c", (kUIACommandKeyMask))
	target.processes()["Finder"].windows()[1].scrollViews()[0].groups()["Image browser"].click()
	target.delayForTimeInterval_(.5)
	keyboard.typeString_withModifiersMask_("v", (kUIACommandKeyMask))
	target.delayForTimeInterval_(.5)
	
	#Broken.. see  7615099
#	hitpoint = target.processes()["Finder"].mainWindow().scrollViews()[0].groups()["Image browser"].images()["FileToCopy"].hitpoint()
#	keyboard.pressKey_(kVK_Option)
#	mouse.dragFrom_to_(target.processes()["Finder"].mainWindow().scrollViews()[0].groups()["Image browser"].images()["FileToCopy"], (hitpoint.x + -200, hitpoint.y + -220))
#	keyboard.releaseKey_(kVK_Option)
	
	target.processes()["Finder"].mainWindow().scrollViews()[0].buttons()["Replace"].click()
	for i in range(1, 8):
		target.delayForTimeInterval_(1)
		if not (target.processes()["Finder"].mainWindow().scrollViews()[0].buttons()["stop progress"].isValid()):  #wait for the copy to complete
			#could also use target.processes()["Finder"].mainWindow().scrollViews()[0].progressBars()[0]
			break
	commandOutput = doCommand("diff", FileToCopy1, FileToCopy2)
	if commandOutput['status'] == 0:
		logPass()
	else:
		logFail("Copying an item failed the diff test: " + str(commandOutput['stdout']))
		

def finishTest(params):
	keyboard.typeVirtualKey_withModifiersMask_(13, (kUIAOptionKeyMask|kUIACommandKeyMask))
	
# def cleanupScenario(params):
	# Cleanup any changes done by your test
	raftlibs.finder.deleteFileOrFolder(FolderFullPath1)
	raftlibs.finder.deleteFileOrFolder(FolderFullPath2)

# def restoreSystem(params):
	# One-time restoration of the system after completing your script