#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("~finder/Automation/raft-wrapper.py")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
GoToBasic
 
Contact: Lindsey H
2009/12/02
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "QuickLook test for GoTo"                 # Add a brief description of test functionality
testVersion      = "1.0"              # Your test version must be increased if you change testCustomDBSpec or testState
testState        = ProductionState   # Possible values: DevelopmentState, ProductionState
testCustomDBSpec = {}                 # for the exceptional case when custom data fields are needed (see wiki)


@runAsSubTest("GoTo Home and open window")	
def GoToHomeandOpenWindow():
	
	keyboard.typeString_withModifiersMask_("g", (kUIAShiftKey|kUIACommandKey))
	target.delayForTimeInterval_(.50)
	keyboard.typeString_("~/Downloads")
	keyboard.typeVirtualKey_(kVK_Return)
	target.delayForTimeInterval_(1.50)
	if (target.processes()["Finder"].mainWindow().name() == "Downloads"):
		logPass()
	else:
		logFail("Could not Go To the Downloads folder")

@runAsSubTest("GoTo Documents folder using auto-complete")	
def GoToAutoCompleteDocuments():
	
	keyboard.typeString_withModifiersMask_("g", (kUIAShiftKey|kUIACommandKey))
	target.delayForTimeInterval_(.50)
	keyboard.typeString_("~/Doc")
	#keyboard.typeVirtualKey_(kVK_Tab)
	target.delayForTimeInterval_(1.50)
	keyboard.typeVirtualKey_(kVK_Return)
	target.delayForTimeInterval_(1.50)
	if (target.processes()["Finder"].mainWindow().name() == "Documents"):
		logPass()
	else:
		logFail("Could not Go To the Documents folder using auto-complete")
	
def runTest(params):

	#Start with no windows
	raftlibs.finder.closeAllWindows()
	
	GoToHomeandOpenWindow()
	GoToAutoCompleteDocuments()
	