#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("~finder/Automation/raft-wrapper.py")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
Customize Toolbar Test

Contact: Lindsey H
2009/11/30
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "QuickLook test for customizing the toolbar"                 # Add a brief description of test functionality
testVersion      = "1.1"              # Your test version must be increased if you change testCustomDBSpec or testState
testState        = ProductionState    # Possible values: DevelopmentState, ProductionState
testCustomDBSpec = {}                 # for the exceptional case when custom data fields are needed (see wiki)



@runAsSubTest("Add Item to Toolbar")	
def AddNewFolderToToolbar():

	
	target.dock().dockItems()["Finder"].click()
	target.processes()["Finder"].menus()["View"].menuItems()[u"Customize Toolbar…"].choose()
	mouse.dragFrom_to_(target.processes()["Finder"].mainWindow().sheet().elements()[4].images()["New Folder toolbar item"], target.processes()["Finder"].mainWindow().toolbar())

	target.processes()["Finder"].mainWindow().sheet().buttons()["Done"].click()
	
	if (len(target.processes()["Finder"].mainWindow().toolbar().buttons()) < 2):
		logFail("New Folder toolbar item was not added")
	else:
		logPass()

@runAsSubTest("Remove Item from Toolbar")	
def RemoveNewFolderFromToolbar():
	
	
	target.dock().dockItems()["Finder"].click()
	
	hitpoint = target.processes()["Finder"].mainWindow().toolbar().buttons()["New Folder"].hitpoint()
	keyboard.pressKey_(kVK_Command)
	mouse.dragFrom_to_(target.processes()["Finder"].mainWindow().toolbar().buttons()["New Folder"], (hitpoint.x + -4, hitpoint.y + -73))
	keyboard.releaseKey_(kVK_Command)
	
	if (len(target.processes()["Finder"].mainWindow().toolbar().buttons()) > 1):
		logFail("New Folder toolbar item was not removed")
	else:
		logPass()
	


def runTest(params):

	raftlibs.finder.resetToolbarState()
	
	AddNewFolderToToolbar()
	RemoveNewFolderFromToolbar()
