#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
QuickLook_N_RunThruGroupViewOptions

Contact: vanberckel@apple.com
2010/07/23
"""

# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Runs through all the possible view styles"                 # Add a brief description of test functionality
testVersion      = "1.0"              # Used to differentiate between results for different versions of the test
testState        = DevelopmentState   # Possible values: DevelopmentState, ProductionState
testSampleFile   = "~/RunThruGroupViewOptionsSampleFile"

#monitoredProcesses  = ["Finder"]       # A list of processes to track during performance or other testing

import random

# def configureSystem(params):
	# One-time configuration of the system before starting your script.

def prepareScenario(params):
	for i in range(1, 10):
		doCommand("touch",os.path.expanduser(testSampleFile + str(i) + ".txt") )
	target.dock().dockItems()["Finder"].click()
	raftlibs.finder.resetToolbarState()
#	raftlibs.finder.closeAllWindows()
#	keyboard.typeVirtualKey_withModifiersMask_(13, (kUIAOptionKeyMask|kUIACommandKeyMask))
	keyboard.typeString_withModifiersMask_("n", (kUIACommandKeyMask))
	keyboard.typeString_withModifiersMask_("h", (kUIAShiftKeyMask|kUIACommandKeyMask))
	try:
		target.processes()["Finder"].menus()["View"].menuItems()["Show Toolbar"].choose()
	except:
		pass

def cycleViewOptionsRandomly(numTimes):
	for i in range(1,numTimes+1):
		keyboard.typeString_withModifiersMask_("h", (kUIAShiftKeyMask|kUIACommandKeyMask))
		keyboard.typeString_withModifiersMask_(str(random.randrange(1,5)), (kUIACommandKeyMask))
		target.delayForTimeInterval_(.25)

def cycleGroupViews():
	arrangeByMenu = target.processes()["Finder"].mainWindow().toolbar().menuButtons()["Arrange"]
	arrangeByMenu.click()
	target.processes()["Finder"].mainWindow().toolbar().menuButtons()["Arrange"].menuItems()["None"].choose()
	arrangeByMenu.click()
	x = len(arrangeByMenu.elements())
	for i in range(2,x):#starting at 2 because we skip "none" and the separator
#		if (arrangeByMenu.menuItems()[i].isSeparatorItem() == 0):
		arrangeByMenu.click()
		arrangeByMenu.openMenu().menuItems()[i].choose()		
		target.delayForTimeInterval_(.25)
		
def cycleAllViewPermutations():
	for i in range(1,5):
		keyboard.typeString_withModifiersMask_(str(i), (kUIACommandKeyMask))#for each view (icon, list etc)
		cycleGroupViews()		#cycle the group views

def runTest(params):
	cycleViewOptionsRandomly(10)
	target.processes()["Finder"].mainWindow().toolbar().radioButtons()["icon view"].click()
	cycleGroupViews()
	cycleAllViewPermutations()
	
	target.processes()["Finder"].mainWindow().toolbar().radioButtons()["icon view"].click()
	try:
		target.processes()["Finder"].menus()["View"].menuItems()["Show View Options"].choose()
	except:
		pass
	target.processes()["Finder"].frontWindow().dragTo_((40,200))
	target.processes()["Finder"].mainWindow().toolbar().menuButtons()["Arrange"].openMenu().menuItems()["None"].choose()
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].dragToValue_(0.000)
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].dragToValue_(112.000)
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].dragToValue_(0.000)
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].click()
	target.processes()["Finder"].frontWindow().sliders()["Grid spacing:"].dragToValue_(100.000)
	target.processes()["Finder"].frontWindow().sliders()["Grid spacing:"].dragToValue_(1.000)
	target.processes()["Finder"].frontWindow().sliders()["Grid spacing:"].click()	
	
	target.processes()["Finder"].mainWindow().toolbar().menuButtons()["Arrange"].openMenu().menuItems()[2].choose()
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].dragToValue_(0.000)
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].dragToValue_(112.000)
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].dragToValue_(0.000)
	target.processes()["Finder"].frontWindow().sliders()["Icon size:"].click()
	target.processes()["Finder"].frontWindow().sliders()["Grid spacing:"].dragToValue_(1.000)
	target.processes()["Finder"].frontWindow().sliders()["Grid spacing:"].dragToValue_(100.000)
	target.processes()["Finder"].frontWindow().sliders()["Grid spacing:"].dragToValue_(1.000)
	target.processes()["Finder"].frontWindow().sliders()["Grid spacing:"].click()	


	logPass()

# def finishTest(params):
	# Return to a state so the test may be run again

def cleanupScenario(params):
	# Cleanup any changes done by your test
	for i in range(1, 10):
		raftlibs.finder.deleteFileOrFolder(os.path.expanduser(testSampleFile + str(i) + ".txt"))
		
# def restoreSystem(params):
	# One-time restoration of the system after completing your script
