#!/usr/bin/python
# -*- coding: utf-8 -*-
if __name__ == '__main__':
	# The following code allows this test to be invoked outside the harness and should be left unchanged
	import os, sys
	args = [os.path.realpath(os.path.expanduser("/AppleInternal/Raft/Harness/raft")), "-f"] + sys.argv
	os.execv(args[0], args)

"""
QuickLook_N_RunThruGetInfoWindow

Contact: vanberckel@apple.com
2010/02/09
"""


# This is a Raft test. For more information see http://raft.apple.com
testDescription  = "Goes through almost all items in the Info Window"
testVersion      = "1.2"              # Your test version must be increased if you change testCustomDBSpec or testState
testState        = ProductionState   # Possible values: DevelopmentState, ProductionState
testFileName	 = "RunThruGetInfoWindowSampleFile.txt"
testFilePath	 = "~/" + testFileName
altTestFileName = "testFileName.txt"
altTestFilePath = "~/" + altTestFileName

def prepareScenario(params):
	if not (raftlibs.finder.deleteFileOrFolder(testFilePath)):
		raise Exception("Could not remove" + testFileName)
	if not (raftlibs.finder.deleteFileOrFolder(altTestFilePath)):
		raise Exception("Could not remove" + altTestFileName)
		
	doCommand("touch",os.path.expanduser(testFilePath))
	
	raftlibs.finder.closeAllWindows()
	keyboard.typeString_withModifiersMask_("h", (kUIAShiftKeyMask|kUIACommandKeyMask))
	target.delayForTimeInterval_(1)
	keyboard.typeString_("Run")
	keyboard.typeString_withModifiersMask_("i", (kUIACommandKeyMask))
	if not (target.processes()["Finder"].mainWindow().name() == (testFileName + " Info")):
		raise Exception("Could not get info on " + testFileName)

def runTest(params):
	# Your testing code here
	
	infoWindow = target.processes()["Finder"].mainWindow()
	scrollView = infoWindow.scrollViews()[0]
	disclosureTriangles = scrollView.disclosureTriangles()
	scDisclosureTriangle = disclosureTriangles["Spotlight Comments:"]
	
	# start with a known state: all the slices collapsed (see 8542978)
	if (scDisclosureTriangle.value() == 0):
		scDisclosureTriangle.click()
	keyboard.pressKey_(kVK_Option)
	scDisclosureTriangle.click()
	keyboard.releaseKey_(kVK_Option)
		
	# expand all slices one by one, from bottom to top so raft doesn't get
	# confused if a scroll bar appears.  (see 8542978)
	numOfSlices = len(disclosureTriangles)
	for i in range(numOfSlices - 1, -1, -1):
		disclosureTriangles[i].click()
	
	# ok lets do all at once just for fun, ending with them all collapsed again
	keyboard.pressKey_(kVK_Option)
	scDisclosureTriangle.click()
	target.delayForTimeInterval_(2)		# wait for the animation to complete
	scDisclosureTriangle.click()
	keyboard.releaseKey_(kVK_Option)
	
	# copy the icon to the clipboard
	#
	# [TODO] paste an icon from some known node (e.g. TextEdit) onto the text file
	# Steps: Select the known node, press Command-C, click in the Icon in the info window
	# and press Command-V.
	scrollView.images()[testFileName].click()
	keyboard.typeString_withModifiersMask_("c", (kUIACommandKeyMask))
	
	#---Spotlight
	scrollView.textViews()[0].click()
	keyboard.typeString_withModifiersMask_("a", (kUIACommandKeyMask))
	keyboard.typeString_("Some Comment")
	keyboard.typeVirtualKey_(kVK_Return)
	
	#---General
	# click each gumbdrop, finishing with the "X" label.
	numOfLabels = len(scrollView.radioButtons())
	for i in range(0, numOfLabels):
		scrollView.radioButtons()[i].click()
	scrollView.radioButtons()[0].click()

	# toggle the Stationary Pad checkbox
	checkboxes = scrollView.checkboxes()
	stationaryPadCheckbox = checkboxes["Stationery pad"]
	if (stationaryPadCheckbox.value() == 1):
		stationaryPadCheckbox.click()
	else:
		stationaryPadCheckbox.click()
		stationaryPadCheckbox.click()
	
	# toggle the Locked checkbox
	lockedCheckbox = checkboxes["Locked"]
	if(lockedCheckbox.value() == 1):
		lockedCheckbox.click()
	else:
		lockedCheckbox.click()
		lockedCheckbox.click()
	# wait for the ui to update the enabled/disabled states of the other controls
	target.delayForTimeInterval_(1)

	#---Name & Extension

	nameTextField = scrollView.textFields()[0]
	nameTextField.click()
	
	# rename the file to .foo.txt, which will fail and present an error dialog
	# and revert the name in the text field back to testFileName
	keyboard.typeString_withModifiersMask_("a", (kUIACommandKeyMask))
	keyboard.typeString_(".foo.txt")
	keyboard.typeVirtualKey_(kVK_Return)
	target.processes()["Finder"].frontWindow().buttons()["OK"].click()
	if not (nameTextField.value() == testFileName):
		raise Exception("Name text field did not revert back to" + testFileName)		

	# rename the file to altTestFileName
	keyboard.typeString_withModifiersMask_("a", (kUIACommandKeyMask))
	keyboard.typeString_(altTestFileName)
	keyboard.typeVirtualKey_(kVK_Return)
	
	# rename the file back to testFileName
	keyboard.typeString_withModifiersMask_("a", (kUIACommandKeyMask))
	keyboard.typeString_(testFileName)
	keyboard.typeVirtualKey_(kVK_Return)
	
	# toggle the hide extension checkbox
	hideExtensionCheckbox = checkboxes["Hide extension"]
	if(hideExtensionCheckbox.value() == 1):
		hideExtensionCheckbox.click()
	else:
		hideExtensionCheckbox.click()
		hideExtensionCheckbox.click()

	#---Open With
	openWithPopup = scrollView.popUpButtons()[0]
	openWithPopup.openMenu()
	target.delayForTimeInterval_(4)	# wait for the menu to populate
	openWithPopup.openMenu().menuItems()[2].choose()	
	target.delayForTimeInterval_(1)
	openWithPopup.openMenu().menuItems()[0].choose()
	
	scrollView.buttons()[u"Change All…"].click()
	target.delayForTimeInterval_(2)
	target.processes()["Finder"].frontWindow().buttons()["Cancel"].click()
	
	#---Sharing & Permissions
	#
	# Note: at this point in the script, the Sharing & Permissions slice may be scrolled out of view
	# depending on the height of the screen, so use .scrollToVisible() inline with the click
	# to guarentee its clickable, otherwise the test will fail.
	#
	# 8627671 covers having raft scroll the button into view automatically.
	scrollView.buttons()["add"].scrollToVisible().click()
	target.delayForTimeInterval_(2)
	infoWindow.sheet().buttons()["Cancel"].click()

	logPass() # This line is implicit and can be removed


def finishTest(params):

	raftlibs.finder.deleteFileOrFolder(testFilePath)
	raftlibs.finder.deleteFileOrFolder(altTestFilePath)


